require( "scripts/style.lua" );



InfoFont = {
  standardFont,
  16,
  BorderColor
};

kRowSpace = 20;
kRightColumn = 360;
kTopPad = 50;


CustomerButtonGraphics = {
	"backgrounds/textfield",
	"backgrounds/textfield",
	"backgrounds/textfield"
};

function MakeRow( row, column, num )
	columnSpace = kRightColumn * column;
	return Group(
		{
			Text
			{
				font = InfoFont,
				name = "row"..num,
				x=columnSpace + 20,y=kTopPad + (row * kRowSpace),w=20,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = ""..(num+1)
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=columnSpace + 50,
				y=kTopPad + (row * kRowSpace),
				scale = 0.5,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "timeval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			FillWindow
			{
				x=columnSpace + 160,
				y=kTopPad + (row * kRowSpace),
				w=50,
				h=16,
				r = 0.60,
				g = 0.42,
				b = 0.25,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "defval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			FillWindow
			{
				x=columnSpace + 215,
				y=kTopPad + (row * kRowSpace),
				w=50,
				h=16,
				r = 0.60,
				g = 0.42,
				b = 0.25,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "reserval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			Button
			{
				font = SmallButtonFont,
				type = kPush,
				x=columnSpace + 270,
				y=kTopPad + (row * kRowSpace),
				scale = 0.5,
				graphics = CustomerButtonGraphics,
				Text
				{
					font = SmallButtonFont,
					name = "typeval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
				command =
					function()
						returnval = DoModal("scripts/leveleditor/customers.lua");
						if (not(returnval == nil)) then
							SetWindowText("typeval"..num, returnval);
						end
					end
			};
		}
	)
end

function MakeRows( )
	local windows = {};
	for i=0,24 do
		table.insert(windows, MakeRow(i,0,i));
	end;
	for i=25,49 do
		DebugOut("Column1");
		table.insert(windows, MakeRow(i-25,1,i));
	end;
	return Group(windows);
end

MakeDialog
{
	FillWindow
	{
		x=0,
		y=0,
		w=800,
		h=600,
		r = 0.5,
		g = 0.5,
		b = 0.5,
		
		Text
		{
			font = InfoFont,
			name = "time",
			x=50,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_time"
		};
		
		Text
		{
			font = InfoFont,
			name = "def",
			x=130,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_def"
		};
		
		Text
		{
			font = InfoFont,
			name = "def",
			x=200,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_reservation"
		};
		
		Text
		{
			font = InfoFont,
			name = "type",
			x=270,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_type"
		};
		
		
		Text
		{
			font = InfoFont,
			name = "time",
			x=50+kRightColumn,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_time"
		};
		
		Text
		{
			font = InfoFont,
			name = "def",
			x=160+kRightColumn,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_def"
		};
		
		Text
		{
			font = InfoFont,
			name = "def",
			x=215+kRightColumn,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_reservation"
		};
		
		Text
		{
			font = InfoFont,
			name = "type",
			x=270+kRightColumn,y=20,w=100,h=20,
			flags = kHAlignCenter + kVAlignTop,
			label = "le_type"
		};
		
		MakeRows();
		
		Button
		{
			x=kCenter,
			y=550,
			font = StandardButtonFont,
			graphics = SolidButtonGraphics,
			name="back",
			label="back",
			type = kPush,
			command=
				function()
					RecordCustomers();
					PopModal("scripts/leveleditor/careermode.lua");
				end
		},
	}
}

SetupCustomers();


